#!/bin/bash

# © ООО «1С-Софт», 1996-2023. Все права защищены
# Copyright © 1C-Soft LLC, 1996-2023. All rights reserved

if [ `which lsb_release 2>/dev/null` ]; then
    distrName=`lsb_release -is`
else
    distrName=`cat /etc/os-release | grep ^ID= | cut -d= -f2 | tr -d '"'`
fi

function failedPacks_format()
{
    [ -z "$failedPacks" ] && failedPacks="$1" || failedPacks="$failedPacks $1"
}

function check_dpkg()
{
    [ -z "$APTPACKS" ] && { APTPACKS=`dpkg -l | awk '/^[hi]i/{print $2}'`; }
    test `echo "$APTPACKS" | grep "$1" | wc -l` -eq 0
}

function create_enchant1_symlink()
{
    for f in `find /usr -type l -name "libenchant*.so.2"`; do
        pushd `dirname $f` >/dev/null
        [ ! -f libenchant.so.1 ] && ln -s `basename $f` libenchant.so.1 || :
        popd >/dev/null
        break
    done
}

function install_apt()
{
    if check_dpkg "$1"; then
        if [[ "$1" == *enchant* ]]; then
            apt-get install -y $1 >/dev/null 2>&1
            if check_dpkg "$1" && [ `echo "$APTPACKS" | grep "libenchant" | wc -l` -eq 0 ]; then
                apt-get install -y libenchant*2-[0-9]* >/dev/null 2>&1 || failedPacks_format $1
            fi
            create_enchant1_symlink
        else
            apt-get install -y $1 >/dev/null 2>&1 || failedPacks_format $1
        fi
    fi
}

function install_apt_final_error_msg()
{
    [ -z "$failedPacks" ] || ERRORMSG=`apt-get install -y "$failedPacks" 2>&1>/dev/null`
}

function install_dpkg()
{
    if check_dpkg "$1"; then
        dpkg -i $1 >/dev/null 2>&1 || failedPacks_format $1
    fi
}

function check_rpm()
{
    [ -z "$YUMPACKS" ] && { YUMPACKS=`rpm -qa --queryformat '%{NAME}\n'`; }
    test `echo "$YUMPACKS" | grep -Fx "$1" | wc -l` -eq 0
}

function install_yum()
{
    if check_rpm "$1"; then
        if [[ "$1" == *enchant* ]]; then
            yum install -y $1 >/dev/null 2>&1
            if check_rpm "$1" && [ `echo "$YUMPACKS" | grep "enchant2" | wc -l` -eq 0 ]; then
                yum install -y enchant*2-[0-9]* >/dev/null 2>&1 || failedPacks_format $1
            fi
            create_enchant1_symlink
        else
            yum install -y $1 >/dev/null 2>&1 || failedPacks_format $1
        fi
    fi
}

function install_yum_final_error_msg()
{
    [ -z "$failedPacks" ] || ERRORMSG=`yum install -y "$failedPacks" 2>&1>/dev/null`
}

case "$distrName" in
    "ALT"*| \
    "altlinux"*)
        for p in polkit zenity xmessage evince libwebkit2gtk; do install_apt $p; done
        install_yum_final_error_msg
    ;;
    "Fedora"*| \
    "fedora"*)
        for p in polkit zenity xmessage evince webkit2gtk3; do install_yum $p; done
        install_yum_final_error_msg
    ;;
    "OracleServer"*| \
    "ol"*| \
    "RedHatEnterprise"*| \
    "rhel"*)
        for p in polkit zenity evince webkit2gtk3; do install_yum $p; done
        install_yum_final_error_msg
    ;;
    "RED SOFT"*| \
    "redos"*)
        for p in polkit zenity xorg-x11-apps evince webkit2gtk3; do install_yum $p; done
        install_yum_final_error_msg
    ;;
    "CentOS"*| \
    "centos"*)
        for p in polkit zenity xorg-x11-apps evince; do install_yum $p; done
        if [ `which lsb_release 2>/dev/null` ]; then
            distrVer=`lsb_release -r | awk '{print $NF}' | cut -d'.' -f1`
        else
            distrVer=`cat /etc/os-release | grep "^VERSION_ID=" | cut -d'=' -f2 | cut -d'.' -f1 | tr -d '"'`
        fi
        [ "$distrVer" = "7" ] && install_yum webkitgtk4 || install_yum webkit2gtk3
        install_yum_final_error_msg
     ;;
     "AstraLinux"*| \
     "astra"*)
        for p in policykit-1 zenity x11-utils libwebkit2gtk-4.0-[0-9]; do install_apt $p; done
        install_yum_final_error_msg
     ;;
    *)
        for p in policykit-1 zenity x11-utils evince libwebkit2gtk-4.0-[0-9]; do install_apt $p; done
        install_yum_final_error_msg
    ;;
esac
[ -z "$failedPacks" ] || { NL=$'\n'; echo "$NL$failedPacks$NL$NL$ERRORMSG"; }
